unit xydrv;

interface

const
  XY_IDLE     = 0;
  XY_RUNNING  = -1;
  (* error codes *)
  XY_NO_ERROR              = 0;
  XY_UNKNOWN_ERROR         = 300;
  XY_ALREADY_ACTIVE_ERROR  = 301;
  XY_CANNOT_OPEN_ERROR     = 302;
  XY_EMPTY_FILE_ERROR      = 303;
  XY_NO_STARTUP_CHAR_ERROR = 304;
  XY_NOT_NCG_ERROR         = 305;
  XY_DISK_READ_ERROR       = 306;
  XY_NO_EOT_ACK_ERROR      = 307;
  XY_INTERNAL_ERROR        = 308;
  XY_CANCELLED_ERROR       = 309;
  XY_OUT_OF_SYNC_ERROR     = 310;
  XY_RETRIES_ERROR         = 311;
  XY_BAD_PACKET_NBR_ERROR  = 312;
  XY_TIMED_OUT_ERROR       = 313;
  XY_NO_SUCH_FILE_ERROR    = 314;
  XY_NOT_ACTIVE_ERROR      = 315;
  XY_PORT_RANGE_ERROR      = 316;
  (* xyGetParameter commands *)
  XY_GET_ERROR_CODE     =  0;
  XY_GET_ERROR_STATE    =  1;
  XY_GET_PACKET         =  2;
  XY_GET_STATE          =  3;
  XY_GET_FILE_SIZE      =  4;
  XY_GET_NBR_NAKS       =  5;
  XY_GET_DEBUG          =  6;
  XY_GET_LAST_GET       =  7;
  XY_GET_LAST_PUT       =  8;
  XY_GET_GET_COUNT      =  9;
  XY_GET_PUT_COUNT      = 10;
  XY_GET_DRIVER_COUNT   = 11;

function xyAcquire(Port:Integer) : Integer;
function xyRelease(Port:Integer) : Integer;
function xyAbort(Port:Integer) : Integer;
function xyDebug(Level:Integer) : Integer;
function xyDriver(Port:Integer) : Integer;
function xyGetMessage(Buffer:PChar; Size:Integer) : Integer;
function xyGetFilename(Buffer:PChar; Size:Integer) : Integer;
function xyGetParameter(Port:Integer; Parameter:Integer) : Integer;
function xyStartTx(Port:Integer; Filename:PChar; OneKflag:Integer; BatchFlag:Integer) : Integer;
function xyStartRx(Port:Integer; Filename:PChar; NCGchar:Char; BatchFlag:Integer) : Integer;

implementation

function xyAcquire; external 'XYDRV16';
function xyRelease; external 'XYDRV16';
function xyAbort; external 'XYDRV16';
function xyDebug; external 'XYDRV16';
function xyDriver; external 'XYDRV16';
function xyGetMessage; external 'XYDRV16';
function xyGetFilename; external 'XYDRV16';
function xyGetParameter; external 'XYDRV16';
function xyStartTx; external 'XYDRV16';
function xyStartRx; external 'XYDRV16';
end.
